/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.quest.area;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import dev.toma.gunsrpg.common.quests.quest.area.IMobSpawnProcessor;
import dev.toma.gunsrpg.common.quests.quest.area.IMobSpawnProcessorSerializer;
import dev.toma.gunsrpg.common.quests.quest.area.IMobTargettingContext;
import dev.toma.gunsrpg.common.quests.quest.area.MobSpawnProcessorType;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class SetEffectProcessor
implements IMobSpawnProcessor {
    private final MobSpawnProcessorType<SetEffectProcessor> type;
    private final Effect effect;
    private final int duration;
    private final int amplifier;
    private final boolean ambient;
    private final boolean visible;

    public SetEffectProcessor(MobSpawnProcessorType<SetEffectProcessor> type, Effect effect, int duration, int amplifier, boolean ambient, boolean visible) {
        this.type = type;
        this.effect = effect;
        this.duration = duration;
        this.amplifier = amplifier;
        this.ambient = ambient;
        this.visible = visible;
    }

    @Override
    public MobSpawnProcessorType<?> getType() {
        return this.type;
    }

    @Override
    public void processMobSpawn(LivingEntity entity, IMobTargettingContext targettingContext) {
        entity.func_195064_c(new EffectInstance(this.effect, this.duration, this.amplifier, this.ambient, this.visible));
    }

    public static final class Serializer
    implements IMobSpawnProcessorSerializer<SetEffectProcessor> {
        @Override
        public SetEffectProcessor deserialize(MobSpawnProcessorType<SetEffectProcessor> type, JsonElement element) throws JsonParseException {
            JsonObject object = JsonHelper.asJsonObject(element);
            ResourceLocation effectId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"effect"));
            Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(effectId);
            if (effect == null) {
                throw new JsonSyntaxException("Unknown effect: " + effectId);
            }
            int duration = JSONUtils.func_151208_a((JsonObject)object, (String)"duration", (int)600);
            int amplifier = JSONUtils.func_151208_a((JsonObject)object, (String)"amplifier", (int)0);
            boolean ambient = JSONUtils.func_151209_a((JsonObject)object, (String)"ambient", (boolean)false);
            boolean visible = JSONUtils.func_151209_a((JsonObject)object, (String)"visible", (boolean)true);
            return new SetEffectProcessor(type, effect, duration, amplifier, ambient, visible);
        }

        @Override
        public void toNbt(SetEffectProcessor processor, CompoundNBT nbt) {
            nbt.func_74778_a("effect", processor.effect.getRegistryName().toString());
            nbt.func_74768_a("duration", processor.duration);
            nbt.func_74768_a("amplifier", processor.amplifier);
            nbt.func_74757_a("ambient", processor.ambient);
            nbt.func_74757_a("visible", processor.visible);
        }

        @Override
        public SetEffectProcessor fromNbt(MobSpawnProcessorType<SetEffectProcessor> type, CompoundNBT nbt) {
            Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(nbt.func_74779_i("effect")));
            int duration = nbt.func_74762_e("duration");
            int amplifier = nbt.func_74762_e("amplifier");
            boolean ambient = nbt.func_74767_n("ambient");
            boolean visible = nbt.func_74767_n("visible");
            return new SetEffectProcessor(type, effect, duration, amplifier, ambient, visible);
        }
    }
}

